PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144771570"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line using Multiple Run"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144771323
  Nodes = 
   {
   Output("Ftype",36,-36)
    {
    Type = Integer
    }
   Output("F",36,0)
    {
    Type = Integer
    }
   Output("B",36,-54)
    {
    Type = Integer
    Dim  = [4]
    }
   Output("Fdur",36,18)
    {
    Type = Real
    }
   Output("FTime",36,-18)
    {
    Type = Real
    }
   Output("Floc",36,72)
    {
    Type = Integer
    }
   Input("V1",36,54)
    {
    Type = Real
    Dim  = [3]
    }
   Input("I3",36,36)
    {
    Type = Real
    Dim  = [3]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-25,-55,27,76)
   Pen(Gray)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,0,36,0)
   Line(27,-54,36,-54)
   Line(34,-36,27,-36)
   Pen(Gray)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   Line(27,18,34,18)
   Line(27,36,36,36)
   Line(27,54,34,54)
   Line(27,72,36,72)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([54,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,612,162,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([1998,1188],4,0,-1)
    {
    Name = "Fault"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(37820192)
    Meter(37968256)
    Slider(37817336)
    Meter(37771944)
    Meter(37956400)
    Meter(37690560)
    Meter(37971000)
    Meter(37753280)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   0.datalabel([1674,702],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1674,756],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1674,810],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([2034,1062],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([2034,1080],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([2034,1098],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2034,1116],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1404,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 1404,126,1512,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1404,234],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(36891264)
    Slider(36908664)
    Slider(36902136)
    }
   -ControlPanel-([1404,378],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(36894504)
    Slider(36904912)
    Slider(36923712)
    }
   0.datalabel([1674,864],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1404,756],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(36920648)
    Slider(36882992)
    Slider(36879840)
    }
   0.var([1638,864],0,36879840,180)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1638,810],0,36882992,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1638,756],0,36885848,140)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Wire-([1962,504],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1962,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1998,324],0,0,380)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2034,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2034,288],0,36891264,20)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2034,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2034,450],6,36894504,60)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2070,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.tbreakn([1908,324],4,0,280)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1908,504],4,0,70)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1674,324],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1674,378],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1674,432],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1638,378],0,36902136,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1638,432],0,36904912,40)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1674,486],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1638,324],0,36908664,10)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1980,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1980,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1980,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([2016,864],6,0,400)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2052,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2052,648],0,36914016,100)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2052,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.var([1638,702],0,36917440,120)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([2052,810],6,36920648,170)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Sticky-([954,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,108,1080,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "COMTRADE Recorders"
    }
   0.var([1638,486],0,36923712,50)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Wire-([432,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([432,936],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var_pot([396,936],0,36927592,160)
    {
    Name = "Fault Location "
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   -Wire-([1962,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.consti([540,1044],0,0,200)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([522,1224],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([522,1188],0,0,-1)
    {
    Name = "I3a"
    }
   0.datalabel([522,1260],0,0,-1)
    {
    Name = "I3c"
    }
   0.tbreakn([1926,864],4,0,190)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   -ControlPanel-([54,648],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(36927592)
    Dial(37099984)
    Slider(37004152)
    Slider(37001488)
    Slider(37878368)
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(37811520)
    Meter(37851744)
    Slider(37814480)
    Meter(37769032)
    Meter(37777360)
    Meter(37857432)
    Meter(37807016)
    Meter(37973912)
    }
   0.var([612,720],0,37001488,90)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.var([612,684],0,37004152,80)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.3"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([54,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,792,216,1098
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([252,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,792,378,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> BC 
11=> No fault (0)"
    }
   -ControlPanel-([1404,612],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(36914016)
    Slider(36917440)
    Slider(36885848)
    }
   -ControlPanel-([954,162],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(37897088)
    Slider(37894048)
    }
   -ControlPanel-([882,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(37911376)
    Switch(37913984)
    Switch(37916760)
    Switch(37919480)
    }
   -Sticky-([900,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,468,1188,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually.      "
    }
   0.logic([2124,828],0,0,410)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1926,684],4,0,290)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   -Wire-([1836,414],0,0,-1)
    {
    Vertex="0,0;0,360"
    }
   0.logic([2124,684],6,0,420)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([2142,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([2106,324],6,0,450)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([2142,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2178,468],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([2178,324],4,0,-1)
    {
    Name = "B1"
    }
   -Sticky-([1530,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1530,126,1692,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.datalabel([1998,1224],0,0,-1)
    {
    Name = "FaultType"
    }
   0.datamerge([2052,1134],4,0,460)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.export([2088,1152],4,0,480)
    {
    Name = "B"
    }
   0.export([2088,1296],2,0,250)
    {
    Name = "FTime"
    }
   0.datalabel([1998,1296],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([1998,1260],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([738,792],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([684,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.tfaultn([648,792],4,0,110)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Wire-([1998,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1998,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2286,1098],0,0,300)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2286,1134],0,0,320)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2286,1116],0,0,310)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([522,1080],0,0,-1)
    {
    Name = "V1a"
    }
   0.datalabel([2286,1098],2,0,-1)
    {
    Name = "V1a"
    }
   0.datalabel([522,1116],0,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2286,1116],0,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([522,1152],0,0,-1)
    {
    Name = "V1c"
    }
   0.datalabel([2286,1134],0,0,-1)
    {
    Name = "V1c"
    }
   0.import([2232,1170],0,0,220)
    {
    Name = "V1"
    }
   0.datatap([2286,1224],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2286,1260],0,0,350)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2286,1242],0,0,340)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2268,1296],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.import([2232,1296],0,0,260)
    {
    Name = "I3"
    }
   0.datalabel([2286,1224],2,0,-1)
    {
    Name = "I3a"
    }
   0.datalabel([2286,1242],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2286,1260],0,0,-1)
    {
    Name = "I3c"
    }
   0.datalabel([2196,828],2,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([2196,684],4,0,-1)
    {
    Name = "B3"
    }
   -Wire-([2160,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2160,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1836,774],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.logic([2106,468],0,0,440)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1998,504],6,0,430)
    {
    Type = "1"
    Inv = "0"
    }
   0.var_pot([396,864],0,37099984,130)
    {
    Name = "Fault type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "7"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.datalabel([504,936],0,0,-1)
    {
    Name = "Faultloc"
    }
   0.datalabel([1998,1332],0,0,-1)
    {
    Name = "Faultloc"
    }
   -Wire-([1998,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1998,1332],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,414],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   0.logic([2016,684],0,0,390)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1998,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.export([2088,1188],4,0,230)
    {
    Name = "F"
    }
   0.export([2088,1332],2,0,270)
    {
    Name = "Floc"
    }
   0.export([2088,1224],2,0,470)
    {
    Name = "Ftype"
    }
   -Sticky-([2016,1008],0)
    {
    Name = ""
    Font = 1
    Bounds = 2016,1008,2124,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Wire-([2268,1170],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.export([2088,1260],2,0,240)
    {
    Name = "Fdur"
    }
   -Sticky-([2178,1008],0)
    {
    Name = ""
    Font = 1
    Bounds = 2178,1008,2304,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Imports from Main Page"
    }
   0.select([1026,1134],0,0,370)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1062,1134],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([936,1098],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([936,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([1026,1206],3,37114656,210)
    {
    Name = "MREnable"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -SrcFile-([666,1116],0)
    {
   Name = "case3_Multi_run_state_global.emt\\Data.out"
    }
   0.datalabel([504,864],0,0,-1)
    {
    Name = "FaultType_dial"
    }
   0.mrun([576,1116],0,0,360)
    {
    NV = "1"
    VType1 = "2"
    IType1 = "0"
    VType2 = "2"
    IType2 = "0"
    VType3 = "0"
    IType3 = "1"
    VType4 = "0"
    IType4 = "1"
    VType5 = "0"
    IType5 = "1"
    VType6 = "0"
    IType6 = "1"
    V1Label = "FaultType"
    V2Label = "Fault type"
    ENAB = "1"
    V3Label = "Var # 3"
    V4Label = "Var # 4"
    V5Label = "Var # 5"
    V6Label = "Var # 6"
    STDEV = "2.0"
    V1DR = "0.0"
    V2DR = "0.0"
    V3DR = "0.0"
    V4DR = "0.0"
    V5DR = "0.0"
    V6DR = "0.0"
    V1DI = "0"
    V2DI = "0"
    V3DI = "0"
    V4DI = "0"
    V5DI = "0"
    V6DI = "0"
    N1R = "10"
    Min1R = "0.0"
    Inc1R = "360"
    Max1R = "360"
    V1Run1R = "1"
    V1Run6R = "6"
    V1Run2R = "2"
    V1Run7R = "7"
    V1Run3R = "3"
    V1Run8R = "8"
    V1Run4R = "4"
    V1Run9R = "9"
    V1Run5R = "5"
    V1Run10R = "10"
    N1I = "3"
    Min1I = "0"
    Inc1I = "1"
    Max1I = "10"
    V1Run1I = "1"
    V1Run6I = "6"
    V1Run2I = "4"
    V1Run7I = "7"
    V1Run3I = "7"
    V1Run8I = "8"
    V1Run4I = "4"
    V1Run9I = "9"
    V1Run5I = "5"
    V1Run10I = "10"
    N2R = "10"
    Min2R = "0.0"
    Inc2R = "1.0"
    Max2R = "1.0"
    V2Run1R = "1"
    V2Run6R = "6"
    V2Run2R = "2"
    V2Run7R = "7"
    V2Run3R = "3"
    V2Run8R = "8"
    V2Run4R = "4"
    V2Run9R = "9"
    V2Run5R = "5"
    V2Run10R = "10"
    N2I = "2"
    Min2I = "0"
    Inc2I = "1"
    Max2I = "10"
    V2Run1I = "1"
    V2Run6I = "6"
    V2Run2I = "4"
    V2Run7I = "7"
    V2Run3I = "7"
    V2Run8I = "8"
    V2Run4I = "4"
    V2Run9I = "9"
    V2Run5I = "7"
    V2Run10I = "10"
    N3R = "10"
    Min3R = "0.0"
    Inc3R = "1.0"
    Max3R = "1.0"
    V3Run1R = "1"
    V3Run6R = "6"
    V3Run2R = "2"
    V3Run7R = "7"
    V3Run3R = "3"
    V3Run8R = "8"
    V3Run4R = "4"
    V3Run9R = "9"
    V3Run5R = "5"
    V3Run10R = "10"
    N3I = "10"
    Min3I = "0"
    Inc3I = "1"
    Max3I = "10"
    V3Run1I = "1"
    V3Run6I = "6"
    V3Run2I = "2"
    V3Run7I = "7"
    V3Run3I = "3"
    V3Run8I = "8"
    V3Run4I = "4"
    V3Run9I = "9"
    V3Run5I = "5"
    V3Run10I = "10"
    N4R = "10"
    Min4R = "0.0"
    Inc4R = "1.0"
    Max4R = "1.0"
    V4Run1R = "1"
    V4Run6R = "6"
    V4Run2R = "2"
    V4Run7R = "7"
    V4Run3R = "3"
    V4Run8R = "8"
    V4Run4R = "4"
    V4Run9R = "9"
    V4Run5R = "5"
    V4Run10R = "10"
    N4I = "10"
    Min4I = "0"
    Inc4I = "1"
    Max4I = "0"
    V4Run1I = "1"
    V4Run6I = "6"
    V4Run2I = "2"
    V4Run7I = "7"
    V4Run3I = "3"
    V4Run8I = "8"
    V4Run4I = "4"
    V4Run9I = "9"
    V4Run5I = "5"
    V4Run10I = "10"
    N5R = "10"
    Min5R = "0.0"
    Inc5R = "1.0"
    Max5R = "1.0"
    V5Run1R = "1"
    V5Run6R = "6"
    V5Run2R = "2"
    V5Run7R = "7"
    V5Run3R = "3"
    V5Run8R = "8"
    V5Run4R = "4"
    V5Run9R = "9"
    V5Run5R = "5"
    V5Run10R = "10"
    N5I = "10"
    Min5I = "0"
    Inc5I = "1"
    Max5I = "10"
    V5Run1I = "1"
    V5Run6I = "6"
    V5Run2I = "2"
    V5Run7I = "7"
    V5Run3I = "3"
    V5Run8I = "8"
    V5Run4I = "4"
    V5Run9I = "9"
    V5Run5I = "5"
    V5Run10I = "10"
    N6R = "10"
    Min6R = "0.0"
    Inc6R = "1.0"
    Max6R = "1.0"
    V6Run1R = "1"
    V6Run6R = "6"
    V6Run2R = "2"
    V6Run7R = "7"
    V6Run3R = "3"
    V6Run8R = "8"
    V6Run4R = "4"
    V6Run9R = "9"
    V6Run5R = "5"
    V6Run10R = "10"
    N6I = "10"
    Min6I = "0"
    Inc6I = "1"
    Max6I = "10"
    V6Run1I = "1"
    V6Run6I = "6"
    V6Run2I = "2"
    V6Run7I = "7"
    V6Run3I = "3"
    V6Run8I = "8"
    V6Run4I = "4"
    V6Run9I = "9"
    V6Run5I = "5"
    V6Run10I = "10"
    NM = "6"
    OUTNAM = "Data.out"
    Repeat = "1"
    Opt = "2"
    MinMax = "1"
    NDIV = "10"
    MType1 = "2"
    MType2 = "2"
    MType3 = "2"
    MType4 = "2"
    MType5 = "2"
    MType6 = "2"
    RType1 = "3"
    O1Label = "V1A"
    RType2 = "3"
    O2Label = "V1B"
    RType3 = "3"
    O3Label = "V1C"
    RType4 = "3"
    O4Label = "I3A"
    RType5 = "3"
    O5Label = "I3B"
    RType6 = "3"
    O6Label = "I3C"
    }
   0.datalabel([936,1134],0,0,-1)
    {
    Name = "FaultType_dial"
    }
   0.datalabel([936,1098],0,0,-1)
    {
    Name = "FaultType_MR"
    }
   0.datalabel([684,1080],0,0,-1)
    {
    Name = "FaultType_MR"
    }
   -Wire-([630,1080],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([774,1044],0)
    {
    Name = "MR Enable"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Switch(37114656)
    }
   0.datalabel([1134,1134],0,0,-1)
    {
    Name = "FaultType"
    }
   0.datalabel([1800,414],0,0,-1)
    {
    Name = "FaultType"
    }
   -Sticky-([900,864],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,864,1098,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
When the Multiple Run component
is disabled, you must turn this dial to
\"OFF\".  This enables you to control
the fault location using the Fault
Location Dial.
This dial does NOT control the 
multiple run component.

See Chapter 5.2 for more information."
    }
   -Divider-([18,594],0)
    {
    Size(1260,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1278,54],0)
    {
    Size(0,882)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([774,54],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1278,936],0)
    {
    Size(1116,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 1144771322
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1188]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,286],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(37766120,"V1",0,,,)
     }
    Graph([0,286],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37693456,"I1",0,,,)
     }
    Graph([0,572],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37697208,"I10",0,,,)
     }
    PGraph([0,858],[0,0,738,267],"PolyGraph")
     {
     Options = 2
     Curve(37645792,"Br1a",0,,,1)
     Curve(37653792,"Br1b",1,,,1)
     Curve(37684936,"Br1c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1188]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,286],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(37732784,"V3",0,,,)
     }
    Graph([0,286],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37736424,"I3",0,,,)
     }
    Graph([0,572],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37739008,"I30",0,,,)
     }
    PGraph([0,858],[0,0,738,267],"PolyGraph")
     {
     Options = 2
     Curve(37744832,"Br3a",0,,,1)
     Curve(37747608,"Br3b",1,,,1)
     Curve(37750440,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1188]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,286],"y")
     {
     Options = 9
     Units = ""
     Curve(37873456,"V2",0,,,)
     }
    Graph([0,286],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37640600,"I2",0,,,)
     }
    Graph([0,572],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37700960,"I20",0,,,)
     }
    PGraph([0,858],[0,0,738,267],"PolyGraph")
     {
     Options = 2
     Curve(37870504,"Br2a",0,,,1)
     Curve(37656416,"Br2b",1,,,1)
     Curve(37650200,"Br2c",2,,,1)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1188]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1188
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,286],"y")
     {
     Options = 9
     Units = ""
     Curve(37867536,"V4",0,,,)
     Curve(32373344,"V4c",2,,0,)
     }
    Graph([0,286],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37954176,"I4",0,,,)
     }
    Graph([0,572],[0,0,738,286],"Current")
     {
     Options = 9
     Units = ""
     Curve(37741920,"I40",0,,,)
     }
    PGraph([0,858],[0,0,738,267],"PolyGraph")
     {
     Options = 2
     Curve(37580696,"Br4a",0,,,1)
     Curve(37756192,"Br4b",1,,,1)
     Curve(37758976,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144771322
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2322,774],0,37580696,1110)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([414,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([450,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([486,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([414,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([450,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([486,1332],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1836,900],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1854,936],0,0,180)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1854,972],0,0,220)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([306,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([342,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([378,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([306,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([342,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([378,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([90,1530],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2286,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([2052,1008],0,0,300)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2052,972],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2052,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2052,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([2052,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1854,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1854,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1854,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datatap([1854,1008],0,0,260)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2052,936],0,0,200)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2034,900],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1098,1134],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1008,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1044,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1080,1224],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1062,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1044,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1080,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1098,1386],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([2070,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1872,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([360,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([378,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([378,756],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([1890,1062],0,37617024,330)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2088,1062],0,37619992,340)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([792,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([792,558],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([792,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([792,792],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1134,1134],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1062,1134],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1152,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1188,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([576,540],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([576,558],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([576,774],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([558,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([450,522],4,0,560)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-48.2 [MW]"
    Q = "-102.4 [MVAR]"
    }
   -Wire-([522,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([648,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([252,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([648,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1476,1098],4,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1476,1134],4,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1476,1170],4,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1674,1152],4,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1710,1206],0,37640600,840)
    {
    Name = "I2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([2196,990],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([2196,1026],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([2196,1062],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([2232,990],0,37645792,1020)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2286,990],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([2286,1026],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([2322,1062],0,37650200,960)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.datalabel([2196,1116],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([2232,1026],0,37653792,1000)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2322,1026],0,37656416,990)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.datatap([1458,936],0,0,130)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1458,972],0,0,170)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1476,936],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1476,972],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1674,972],2,0,-1)
    {
    Name = "V2B"
    }
   -Wire-([2196,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2196,1188],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([2196,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2196,1224],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([2286,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1224],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1674,936],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2286,1188],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([2286,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1152],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([2286,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1116],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([2286,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2286,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,1062],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1674,1188],4,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([2196,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1674,1008],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1656,1008],0,0,240)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1656,972],0,0,190)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1656,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1656,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1656,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1476,1008],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1458,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1458,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1458,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datatap([1458,1008],0,0,210)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2196,1152],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([2232,1062],0,37684936,970)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1656,936],0,0,150)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1638,900],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1638,900],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2322,1152],0,37690560,830)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1512,1188],0,37693456,880)
    {
    Name = "I1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1674,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1476,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1512,1278],0,37697208,760)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "0.3"
    }
   0.datalabel([1674,1278],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1710,1278],0,37700960,730)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1440,900],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1476,1278],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1836,900],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1872,936],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1872,972],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1872,1008],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([2070,936],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([2070,972],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([2070,1008],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([720,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([756,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([792,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([720,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([756,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([792,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1872,1278],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([2070,1152],4,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2070,1188],4,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2070,1278],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([828,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([864,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([900,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([828,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([864,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([900,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([486,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([486,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2196,900],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2196,936],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2196,774],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2196,810],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2196,846],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2286,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2286,774],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2286,810],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2286,846],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2286,900],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2286,936],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1890,900],0,37732784,140)
    {
    Name = "V3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "250.0"
    }
   0.pgb([1908,1206],0,37736424,810)
    {
    Name = "I3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1908,1278],0,37739008,700)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "3.0"
    }
   0.pgb([2106,1278],0,37741920,680)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2232,774],0,37744832,1120)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2232,810],0,37747608,1100)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2232,846],0,37750440,1080)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2322,936],0,37753280,1030)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2322,810],0,37756192,1090)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2322,846],0,37758976,1070)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([576,792],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1170,1134],2,0,-1)
    {
    Name = "B4"
    }
   0.breaker3([450,738],4,0,480)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-46.64 [MW]"
    Q = "436.6 [MVAR]"
    }
   0.pgb([1494,900],0,37766120,110)
    {
    Name = "V1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "250.0"
    }
   0.pgb([1494,1062],0,37769032,280)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1692,1062],0,37771944,310)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([954,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([990,756],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([990,738],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1008,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2232,1116],0,37777360,900)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([252,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.datalabel([1026,1152],0,0,-1)
    {
    Name = "Breaker"
    }
   0.unity([1062,1350],0,0,520)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([2034,900],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([1080,1422],6,0,570)
    {
    DPath = "0"
    }
   0.datatap([1098,1134],6,0,530)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,1134],6,0,510)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1008,1224],6,0,940)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1224],6,0,930)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1224],6,0,920)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1224],6,0,910)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1224],6,0,890)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1224],6,0,870)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1116,1224],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1170,1242],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1008,1476],0,0,670)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1476],0,0,660)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1476],0,0,650)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1476],0,0,640)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1476],0,0,630)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1476],0,0,620)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1188,1224],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1152,1476],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1170,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1116,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.breaker3([918,738],0,0,610)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "52.08 [MW]"
    Q = "98.77 [MVAR]"
    }
   0.unity([1098,1350],4,0,710)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([2232,900],0,37807016,1060)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([1098,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1134,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1170,1350],2,0,-1)
    {
    Name = "Faulttype"
    }
   0.var([270,702],3,37811520,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([216,702],3,37814480,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1134,702],5,37817336,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1080,702],5,37820192,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.source3R([252,630],6,0,420)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.datatap([1170,1134],6,0,600)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1062,1134],6,0,540)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1872,1188],4,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1872,1152],4,0,-1)
    {
    Name = "I3B"
    }
   0.recorder2_0([792,1404],0,0,690)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([900,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([900,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.tpflt([342,720],0,0,1160)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([540,756],0,0,1150)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   0.tpflt([828,522],4,0,1170)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([828,756],4,0,1130)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1026,720],4,0,1140)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([1008,1476],0,0,-1)
    {
    Name = "F1"
    }
   -Wire-([1080,1530],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1134,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.pgb([2232,1188],0,37851744,800)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2232,1224],0,37854520,740)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2232,1152],0,37857432,850)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   -Bus-([414,486],0,37859880,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.tpflt([540,522],0,0,1190)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Bus-([954,504],0,40434040,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([918,522],0,0,550)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "52.6 [MW]"
    Q = "98.51 [MVAR]"
    }
   0.pgb([2088,900],0,37867536,160)
    {
    Name = "V4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2322,990],0,37870504,1010)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   0.pgb([1692,900],0,37873456,120)
    {
    Name = "V2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   -Sticky-([1440,792],0)
    {
    Name = ""
    Font = 1
    Bounds = 1440,792,1548,828
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1080,1278],0,0,820)
    {
    DPath = "0"
    }
   0.var([1044,1530],0,37878368,410)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = ""
    Collect = "1"
    }
   0.annotation([1044,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.recorder2_0([792,1224],0,0,950)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([90,1188],1,0,270)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([180,1260],0,37894048,350)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.55"
    Units = "s"
    Collect = "1"
    }
   0.var([54,1530],0,37897088,400)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([540,1530],0,0,-1)
    {
    Vertex="0,0;-396,0"
    }
   -Wire-([666,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([666,1548],0,0,-1)
    {
    Vertex="0,0;-414,0"
    }
   0.select([126,1224],6,0,440)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([90,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   0.const([126,1368],1,0,370)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([162,1404],6,0,460)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([162,1224],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([216,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([198,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([90,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([576,1188],1,0,320)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([612,1224],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([576,1368],1,0,390)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([612,1404],6,0,470)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([540,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   -Wire-([666,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([540,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([540,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([126,1152],1,37911376,230)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([162,1332],1,37913984,360)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([612,1152],1,37916760,290)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([612,1332],1,37919480,380)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -Wire-([1710,162],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2034,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2034,216],2,0,-1)
    {
    Name = "I2"
    }
   0.datalabel([1710,144],0,0,-1)
    {
    Name = "Fstart"
    }
   0.datalabel([2034,144],0,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([2034,162],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2034,162],0,0,-1)
    {
    Name = "Fltdur"
    }
   -Wire-([1710,324],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1710,324],0,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([1710,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1710,342],0,0,-1)
    {
    Name = "Fltdur"
    }
   -Wire-([2034,324],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2034,324],0,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([2034,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([2034,342],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([2034,396],2,0,-1)
    {
    Name = "I4"
    }
   0.datalabel([1710,396],2,0,-1)
    {
    Name = "I3"
    }
   -SrcFile-([2250,324],0)
    {
   Name = "case3_Multi_run_state_global.emt\\out400001.ss1"
    }
   -SrcFile-([2250,144],0)
    {
   Name = "case3_Multi_run_state_global.emt\\out200001.ss1"
    }
   0.datalabel([1044,144],0,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([1152,1152],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datalabel([1710,162],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([1440,900],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1026,1350],0,0,-1)
    {
    Name = "F_Loc"
    }
   0.datalabel([1062,162],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1026,126],4,0,-1)
    {
    Name = "Faulttype"
    }
   0.datalabel([1044,198],0,0,-1)
    {
    Name = "I3"
    }
   0.datalabel([1008,216],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([972,234],2,0,-1)
    {
    Name = "F_Loc"
    }
   0.datalabel([1080,180],0,0,-1)
    {
    Name = "Fltdur"
    }
   -Wire-([972,234],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   -Wire-([1008,216],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([1044,198],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([1080,180],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1206,162],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([1044,144],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([1026,126],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   0.datalabel([990,108],4,0,-1)
    {
    Name = "Breaker"
    }
   -Wire-([990,108],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   0.datalabel([1710,216],2,0,-1)
    {
    Name = "I1"
    }
   -Wire-([1710,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1710,198],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1710,216],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1710,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1710,396],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2034,396],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2034,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2034,216],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([2034,198],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([2106,1206],0,37954176,790)
    {
    Name = "I4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2322,1116],0,37956400,860)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([1494,1098],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1494,1152],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1494,1098],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1494,1134],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1494,1170],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([1512,1188],4,0,-1)
    {
    Name = "I1"
    }
   -Wire-([1692,1116],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1692,1170],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1692,1116],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1692,1152],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1692,1188],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1890,1116],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1890,1170],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1890,1116],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1890,1152],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1890,1188],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2088,1116],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2088,1152],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2088,1188],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.pgb([2322,1188],0,37968256,770)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2322,900],0,37971000,1050)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2232,936],0,37973912,1040)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.datalabel([1674,1116],4,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1710,1206],4,0,-1)
    {
    Name = "I2"
    }
   0.datalabel([1872,1116],4,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1908,1206],4,0,-1)
    {
    Name = "I3"
    }
   0.datalabel([2070,1116],4,0,-1)
    {
    Name = "I4A"
    }
   0.pgb([2322,1224],0,37980928,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Sticky-([18,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,36,666,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two parallel 100km transmission lines.  
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible.
- Includes four state components providing output in Doble .ss1 format, ready
  to be used in Doble's ProTesT software."
    }
   -TLine-([576,522],0,38189176,-1)
    {
    Name = "LINE1"
    Date = 1144771324
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,38207960,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,38209096,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([216,432],0,38209488,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,38210568,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([576,738],0,38229432,-1)
    {
    Name = "LINE2"
    Date = 1144771324
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,38230656,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,40852920,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([180,504],0,40853184,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,38249136,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([522,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.source3R([1098,630],2,0,430)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([1044,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 1044,504,1134,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Wire-([414,630],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Sticky-([198,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 198,504,288,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   .Plots_B2([900,396],0,0,20)
    {
    }
   0.datalabel([1710,378],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1710,198],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([2034,198],2,0,-1)
    {
    Name = "V2"
    }
   0.datalabel([2034,378],2,0,-1)
    {
    Name = "V4"
    }
   0.doblestate([2178,360],0,0,1180)
    {
    filename = "out4.ss1"
    Cmnt = "Case 3 Station 4"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.doblestate([2178,180],0,0,1210)
    {
    filename = "out2.ss1"
    Cmnt = "Case 3 Station 2"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.datamerge([2106,1206],4,0,780)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   -Wire-([2088,1170],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([2106,1206],4,0,-1)
    {
    Name = "I4"
    }
   -Wire-([2088,1116],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datamerge([1908,1206],4,0,490)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.datamerge([1710,1206],4,0,580)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.datamerge([1512,1188],4,0,590)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.doblestate([1854,180],0,0,1220)
    {
    filename = "out1.ss1"
    Cmnt = "Case 3 Station 1"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.doblestate([1854,360],0,0,1200)
    {
    filename = "out3.ss1"
    Cmnt = "Case 3 Station 3"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   -SrcFile-([1206,270],0)
    {
   Name = "case3_Multi_run_state_global.emt\\Data.out"
    }
   .Plots_B1([450,396],0,0,10)
    {
    }
   -SrcFile-([1926,144],0)
    {
   Name = "case3_Multi_run_state_global.emt\\out100001.ss1"
    }
   0.recorder2_0([378,1404],0,0,750)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([378,1224],0,0,980)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   .Controls([1242,162],4,0,500)
    {
    }
   -SrcFile-([1926,324],0)
    {
   Name = "case3_Multi_run_state_global.emt\\out300001.ss1"
    }
   -Sticky-([18,234],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,234,414,342
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([36,1026],0)
    {
    Size(1278,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1314,126],0)
    {
    Size(0,1440)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1314,540],0)
    {
    Size(1080,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Sticky-([1350,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1350,162,1656,270
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Note the file references to the .ss1 files are linked to the data
produced in the first run.  To see subsequent run data, use 
Windows Explorer to go to case3_Multiple_run_state.emt."
    }
   -Wire-([846,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([846,738],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.multimeter([504,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([504,738],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,738],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1440,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1638,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2034,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1440,1062],2,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1440,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1638,1062],2,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1638,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1836,1062],2,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1836,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2034,1062],2,0,-1)
    {
    Name = "V4rms"
    }
   -Wire-([2034,1062],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   }
  }
 }

